/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class HighScoreManager
implements CommandListener,
RecordComparator {
    final int MAX;
    final int LENGTH_OF_NAME;
    String game_name_;
    String name_to_enter_;
    int score_to_enter_;
    int number_of_entries_ = 0;
    String[] names_;
    int[] score_;
    String stored_record_name_ = "HighScore";
    RecordStore stored_highscore_;
    Display display_;
    Displayable last_display_;
    Form enter_name_form_;
    TextField name_field_;
    Command back_command_ = new Command("back", 2, 0);
    Command next_command_ = new Command("next", 1, 0);

    public HighScoreManager(Display display, String string) {
        this.MAX = 10;
        this.LENGTH_OF_NAME = 12;
        this.game_name_ = string;
        this.display_ = display;
        this.score_ = new int[10];
        this.names_ = new String[10];
        this.number_of_entries_ = 0;
        this.readDataFromStore();
        this.initForms();
    }

    void initForms() {
        this.name_field_ = new TextField("Name:", "", 12, 0);
        this.enter_name_form_ = new Form("enter HighScore");
        this.enter_name_form_.append((Item)this.name_field_);
        this.enter_name_form_.addCommand(this.next_command_);
        this.enter_name_form_.setCommandListener((CommandListener)this);
    }

    void readDataFromStore() {
        try {
            this.stored_highscore_ = RecordStore.openRecordStore((String)this.stored_record_name_, (boolean)true);
            RecordEnumeration recordEnumeration = this.stored_highscore_.enumerateRecords(null, (RecordComparator)this, true);
            while (recordEnumeration.hasNextElement()) {
                if (this.number_of_entries_ == 10) break;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(recordEnumeration.nextRecord());
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                this.score_[this.number_of_entries_] = dataInputStream.readInt();
                this.names_[this.number_of_entries_] = dataInputStream.readUTF();
                ++this.number_of_entries_;
            }
            this.stored_highscore_.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    boolean isScoreWorthToInsert(int n) {
        if (n <= 0) {
            return false;
        }
        if (this.number_of_entries_ < 10) {
            return true;
        }
        return n > this.score_[9];
    }

    public void addScore(int n) {
        if (!this.isScoreWorthToInsert(n)) {
            return;
        }
        this.last_display_ = this.display_.getCurrent();
        this.display_.setCurrent((Displayable)this.enter_name_form_);
        this.score_to_enter_ = n;
    }

    boolean addScore(String string, int n) {
        int n2 = -1;
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.number_of_entries_) {
            if (this.score_[n3] < n) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 == -1 && this.number_of_entries_ < 10) {
            n2 = this.number_of_entries_;
        }
        int n4 = this.number_of_entries_ - n2;
        if (this.number_of_entries_ == 10) {
            bl = true;
            --n4;
        } else {
            ++this.number_of_entries_;
            bl = false;
        }
        if (n4 != 0) {
            System.arraycopy(this.score_, n2, this.score_, n2 + 1, n4);
            System.arraycopy(this.names_, n2, this.names_, n2 + 1, n4);
        }
        this.score_[n2] = n;
        this.names_[n2] = string;
        return this.doStore(string, n, bl);
    }

    boolean doStore(String string, int n, boolean bl) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(n);
            dataOutputStream.writeUTF(string);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.stored_highscore_ = RecordStore.openRecordStore((String)this.stored_record_name_, (boolean)true);
            if (!bl) {
                this.stored_highscore_.addRecord(byArray, 0, byArray.length);
            } else {
                RecordEnumeration recordEnumeration = this.stored_highscore_.enumerateRecords(null, (RecordComparator)this, true);
                int n2 = 0;
                while (recordEnumeration.hasNextElement()) {
                    n2 = recordEnumeration.nextRecordId();
                }
                this.stored_highscore_.setRecord(n2, byArray, 0, byArray.length);
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void showHighScore() {
        this.last_display_ = this.display_.getCurrent();
        Form form = new Form("HighScore f\u00fcr " + this.game_name_);
        int n = 0;
        while (n < this.number_of_entries_) {
            form.append((Item)new StringItem(this.names_[n] + ": ", String.valueOf(this.score_[n])));
            ++n;
        }
        form.addCommand(this.back_command_);
        form.setCommandListener((CommandListener)this);
        this.display_.setCurrent((Displayable)form);
    }

    public String[][] getHighScore() {
        String[][] stringArray = new String[this.number_of_entries_][2];
        int n = 0;
        while (n < this.number_of_entries_) {
            stringArray[n][0] = this.names_[n];
            stringArray[n][1] = "" + this.score_[n];
            ++n;
        }
        return stringArray;
    }

    public void commandAction(Command command, Displayable displayable) {
        String string = command.getLabel();
        if (command.equals(this.next_command_)) {
            this.name_to_enter_ = this.name_field_.getString();
            this.addScore(this.name_to_enter_, this.score_to_enter_);
        }
        this.display_.setCurrent(this.last_display_);
    }

    public int compare(byte[] byArray, byte[] byArray2) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray2);
        DataInputStream dataInputStream2 = new DataInputStream(byteArrayInputStream2);
        int n = 0;
        int n2 = 0;
        try {
            n = dataInputStream.readInt();
            n2 = dataInputStream2.readInt();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (n > n2) {
            return -1;
        }
        if (n < n2) {
            return 1;
        }
        return 0;
    }
}

