/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Player {
    private static final int MAX_SHOTS = 5;
    private int width_;
    private final int height_;
    private int speed_ = 8;
    private int pos_x_;
    private int pos_y_;
    private int old_x_;
    private SRCanvas parent_;
    private static Image[] player_images_ = new Image[3];
    private static Image[] shot_images_ = new Image[2];
    private static Image power_image_;
    private boolean moveit_ = false;
    private boolean right_;
    private boolean draw_first_image_ = true;
    private boolean is_hit_ = false;
    private long timestamp_ = 0L;
    private long remove_timestamp_ = 0L;
    public Shot[] shots_ = new Shot[5];
    private int shot_count_ = 0;
    private int power_count_ = 0;

    public Player(SRCanvas sRCanvas, int n) {
        try {
            Player.player_images_[0] = Image.createImage((String)"/spielfigura.png");
            Player.player_images_[1] = Image.createImage((String)"/spielfigurb.png");
            Player.player_images_[2] = Image.createImage((String)"/spielfigurhit.png");
            Player.shot_images_[0] = Image.createImage((String)"/schussa.png");
            Player.shot_images_[1] = Image.createImage((String)"/schussb.png");
            power_image_ = Image.createImage((String)"/powera.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.width_ = player_images_[0].getWidth();
        this.height_ = player_images_[0].getHeight();
        this.parent_ = sRCanvas;
        this.old_x_ = this.pos_x_ = (this.parent_.getMaxX() - this.width_) / 2;
        this.pos_y_ = n;
    }

    public void drawPlayer(Graphics graphics) {
        if (this.is_hit_) {
            graphics.drawImage(player_images_[2], this.pos_x_, this.pos_y_, 20);
        } else if (this.draw_first_image_) {
            graphics.drawImage(player_images_[0], this.pos_x_, this.pos_y_, 20);
        } else {
            graphics.drawImage(player_images_[1], this.pos_x_, this.pos_y_, 20);
        }
        if (this.power_count_ > 0) {
            graphics.drawImage(power_image_, this.pos_x_ - power_image_.getWidth(), this.pos_y_, 0);
        }
        if (this.power_count_ == 2) {
            graphics.drawImage(power_image_, this.pos_x_ + this.width_, this.pos_y_, 0);
        }
        if (this.timestamp_ + 500L < System.currentTimeMillis() && !this.is_hit_) {
            this.timestamp_ = System.currentTimeMillis();
            this.draw_first_image_ = !this.draw_first_image_;
        }
    }

    public void start(boolean bl) {
        this.moveit_ = true;
        this.right_ = bl;
    }

    public void stop() {
        this.moveit_ = false;
    }

    public void move() {
        if (this.is_hit_) {
            if (System.currentTimeMillis() - this.timestamp_ >= 2000L) {
                this.unfreeze();
            }
            return;
        }
        if (this.right_) {
            this.moveRight();
        } else {
            this.moveLeft();
        }
    }

    public boolean isMoving() {
        return this.moveit_;
    }

    public void moveRight() {
        this.pos_x_ += this.speed_;
        if (this.withinBounds()) {
            this.old_x_ = this.pos_x_;
        } else {
            this.pos_x_ = this.power_count_ != 2 ? this.parent_.getWidth() - this.width_ : this.parent_.getWidth() - this.width_ - power_image_.getWidth();
        }
    }

    public void moveLeft() {
        this.pos_x_ -= this.speed_;
        if (this.withinBounds()) {
            this.old_x_ = this.pos_x_;
        } else {
            this.pos_x_ = this.power_count_ == 0 ? 10 : 10 + power_image_.getWidth();
        }
    }

    public boolean shoot() {
        if (this.shot_count_ == 5 || this.is_hit_) {
            return false;
        }
        int n = 0;
        while (n < 5) {
            if (this.shots_[n] == null) {
                this.shots_[n] = new Shot(this.pos_x_ + this.width_ / 2 - 5, this.pos_y_, shot_images_);
                ++this.shot_count_;
                break;
            }
            ++n;
        }
        return true;
    }

    public int getHeight() {
        return this.height_;
    }

    public int getWidth() {
        return this.width_;
    }

    public int getXPos() {
        return this.pos_x_;
    }

    public int getYPos() {
        return this.pos_y_;
    }

    public void resetPlayer() {
        this.pos_x_ = (this.parent_.getMaxX() - this.width_) / 2;
        int n = 0;
        while (n < 5) {
            this.shots_[n] = null;
            ++n;
        }
        this.shot_count_ = 0;
        this.power_count_ = 0;
        this.timestamp_ = 0L;
    }

    boolean withinBounds() {
        switch (this.power_count_) {
            case 0: {
                if (this.pos_x_ < 10 || this.pos_x_ + this.width_ > this.parent_.getWidth()) break;
                return true;
            }
            case 1: {
                if (this.pos_x_ - power_image_.getWidth() < 10 || this.pos_x_ + this.width_ > this.parent_.getWidth()) break;
                return true;
            }
            case 2: {
                if (this.pos_x_ - power_image_.getWidth() < 10 || this.pos_x_ + this.width_ + power_image_.getWidth() > this.parent_.getWidth()) break;
                return true;
            }
        }
        return false;
    }

    public int getMaxShots() {
        return 5;
    }

    public int getShots() {
        return this.shot_count_;
    }

    public void removeShot(int n) {
        this.shots_[n] = null;
        --this.shot_count_;
    }

    public void addPower() {
        if (this.power_count_ < 2) {
            ++this.power_count_;
        }
        if (this.power_count_ == 1 && this.pos_x_ - power_image_.getWidth() < 10) {
            this.pos_x_ = 10 + power_image_.getWidth();
        }
    }

    public boolean removePower() {
        if (this.power_count_ == 0 || this.pos_x_ != 10 + power_image_.getWidth()) {
            this.remove_timestamp_ = System.currentTimeMillis();
            return false;
        }
        if (this.remove_timestamp_ <= System.currentTimeMillis() - 500L) {
            --this.power_count_;
            this.remove_timestamp_ = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public int getPower() {
        return this.power_count_;
    }

    public void freeze() {
        this.is_hit_ = true;
        this.timestamp_ = System.currentTimeMillis();
    }

    public void unfreeze() {
        this.is_hit_ = false;
        this.timestamp_ = 0L;
    }

    public boolean isFreezed() {
        return this.is_hit_;
    }
}

