/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import com.nokia.mid.ui.FullCanvas;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SRCanvas
extends FullCanvas
implements Runnable {
    public static final int MAX_X = 176;
    public static final int MAX_Y = 208;
    public static final int BG_COLOR = 8192120;
    public static final int MAX_MONSTERS = 10;
    public static final int MAX_GOODIES = 15;
    public static final int INITIAL_NUMBER_OF_LINES = 8;
    public static final int MAX_NUMBER_OF_LINES = 17;
    public static final int MAX_EXPLOSIONS = 7;
    private ScreenRobber parent_;
    private volatile Thread animation_thread_ = null;
    private int ms_per_tick_;
    private int standard_ms_per_tick_;
    private long timestamp_ = 0L;
    private long pic_timestamp_ = 0L;
    private long exp_timestamp_ = 0L;
    private Player player_;
    private int level_ = 0;
    private static Image title_image_;
    private static Image arena_image_;
    private static Image game_over_image_;
    private static Image line_image_;
    private static Image[] girl_images_;
    private static Image[] explosion_images_;
    private static Image[][] monster_images_;
    private static Image[][] goodie_images_;
    private boolean show_game_over_ = false;
    private boolean first_ = true;
    private boolean show_level_ = false;
    private boolean show_picture_ = false;
    private boolean sound_on_;
    private boolean paused_ = false;
    private int current_girl_ = 0;
    private Random rnd_;
    private int score_ = 0;
    private int num_lines_;
    private Monster[] monsters_ = new Monster[10];
    private int monster_count_ = 0;
    private long spawn_time_ = 0L;
    private int spawn_interval_ = 2000;
    private Goodie[] goodies_ = new Goodie[15];
    private int goodie_count_ = 0;
    private Explosion[] explosions_ = new Explosion[7];
    private Font font_ = Font.getFont((int)64, (int)1, (int)0);
    private static Sound explosion_sound_;
    private static Sound gameover_sound_;
    private static Sound shot_sound_;
    private static Sound hit_sound_;
    private static Sound line_rem_sound_;

    public SRCanvas(ScreenRobber screenRobber, int n) {
        this.rnd_ = new Random(System.currentTimeMillis());
        this.parent_ = screenRobber;
        this.ms_per_tick_ = this.standard_ms_per_tick_ = n;
        try {
            this.initSounds();
            int n2 = 0;
            while (n2 < 10) {
                SRCanvas.girl_images_[n2] = Image.createImage((String)("/image" + (n2 + 1) + ".jpg"));
                ++n2;
            }
            n2 = 0;
            while (n2 < 5) {
                SRCanvas.monster_images_[n2][0] = Image.createImage((String)("/monster" + (n2 + 1) + "a.png"));
                SRCanvas.monster_images_[n2][1] = Image.createImage((String)("/monster" + (n2 + 1) + "b.png"));
                ++n2;
            }
            line_image_ = Image.createImage((String)"/streifen.png");
            arena_image_ = Image.createImage((String)"/grundscreen.png");
            game_over_image_ = Image.createImage((String)"/gameover.png");
            title_image_ = Image.createImage((String)"/titelxxx.png");
            SRCanvas.explosion_images_[0] = Image.createImage((String)"/explosiona.png");
            SRCanvas.explosion_images_[1] = Image.createImage((String)"/explosionb.png");
            SRCanvas.explosion_images_[2] = Image.createImage((String)"/explosionc.png");
            SRCanvas.goodie_images_[0][0] = Image.createImage((String)"/bombea.png");
            SRCanvas.goodie_images_[0][1] = Image.createImage((String)"/bombeb.png");
            SRCanvas.goodie_images_[1][0] = Image.createImage((String)"/powera.png");
            SRCanvas.goodie_images_[1][1] = Image.createImage((String)"/powerb.png");
        }
        catch (IOException iOException) {
            System.out.println("Fehler beim Laden der Bilder.");
        }
        this.player_ = new Player(this, 195);
    }

    private void initSounds() {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/wav/feindexplosion.wav");
            byte[] byArray = new byte[454];
            inputStream.read(byArray, 0, byArray.length);
            explosion_sound_ = new Sound(byArray, 5);
            explosion_sound_.init(byArray, 5);
            inputStream.close();
            inputStream = this.getClass().getResourceAsStream("/wav/gameover.wav");
            byArray = new byte[520];
            inputStream.read(byArray, 0, byArray.length);
            gameover_sound_ = new Sound(byArray, 5);
            gameover_sound_.init(byArray, 5);
            inputStream.close();
            inputStream = this.getClass().getResourceAsStream("/wav/schuss.wav");
            byArray = new byte[2354];
            inputStream.read(byArray, 0, byArray.length);
            shot_sound_ = new Sound(byArray, 5);
            shot_sound_.init(byArray, 5);
            inputStream.close();
            inputStream = this.getClass().getResourceAsStream("/wav/spielfigurtreffer.wav");
            byArray = new byte[8634];
            inputStream.read(byArray, 0, byArray.length);
            hit_sound_ = new Sound(byArray, 5);
            hit_sound_.init(byArray, 5);
            inputStream.close();
            inputStream = this.getClass().getResourceAsStream("/wav/streifenweg.wav");
            byArray = new byte[11002];
            inputStream.read(byArray, 0, byArray.length);
            line_rem_sound_ = new Sound(byArray, 5);
            line_rem_sound_.init(byArray, 5);
            inputStream.close();
        }
        catch (IOException iOException) {}
    }

    public void paint(Graphics graphics) {
        if (this.paused_) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, this.getHeight() - 20, this.getWidth(), 20);
            graphics.setColor(0);
            String string = "Continue";
            String string2 = "Quit";
            graphics.drawString(string2, 25, this.getHeight() - 10 - Font.getDefaultFont().getHeight() / 2, 0);
            graphics.drawString(string, 120, this.getHeight() - 10 - Font.getDefaultFont().getHeight() / 2, 0);
            return;
        }
        if (this.first_) {
            this.first_ = false;
        }
        graphics.setColor(8192120);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.show_game_over_) {
            graphics.drawImage(arena_image_, 0, 0, 20);
            graphics.drawImage(game_over_image_, 13, 92, 20);
            graphics.setColor(0);
            return;
        }
        if (this.show_picture_) {
            graphics.drawImage(arena_image_, 0, 0, 20);
            graphics.drawImage(girl_images_[this.current_girl_], 13, 92, 20);
            int n = 0;
            while (n < 7) {
                if (this.explosions_[n] != null) {
                    this.explosions_[n].drawExplosion(graphics);
                }
                ++n;
            }
            String string = "Click to continue!";
            int n2 = (this.getWidth() - this.font_.stringWidth(string)) / 2;
            SRCanvas sRCanvas = this;
            int n3 = this.getHeight() - sRCanvas.font_.getDefaultFont().getHeight() - 3;
            graphics.setColor(0xFFFFFF);
            graphics.setFont(this.font_);
            graphics.drawString(string, n2, n3, 0x10 | 4);
            return;
        }
        if (this.show_level_) {
            this.showLevelScreen(graphics);
            return;
        }
        graphics.drawImage(arena_image_, 0, 0, 20);
        graphics.drawImage(girl_images_[this.current_girl_], 13, 92, 20);
        int n = 0;
        while (n < this.num_lines_) {
            graphics.drawImage(line_image_, 13, 92 + n * (line_image_.getHeight() + 1), 0);
            ++n;
        }
        int n4 = this.player_.getMaxShots();
        n = 0;
        while (n < n4) {
            if (this.player_.shots_[n] != null) {
                this.player_.shots_[n].drawShot(graphics);
            }
            ++n;
        }
        n = 0;
        while (n < 10) {
            if (this.monsters_[n] != null) {
                this.monsters_[n].drawMonster(graphics);
            }
            ++n;
        }
        n = 0;
        while (n < 15) {
            if (this.goodies_[n] != null) {
                this.goodies_[n].drawGoodie(graphics);
            }
            ++n;
        }
        this.player_.drawPlayer(graphics);
    }

    protected void keyPressed(int n) {
        if (this.show_level_ || this.show_game_over_) {
            return;
        }
        if (this.show_picture_ && System.currentTimeMillis() - this.pic_timestamp_ >= 2000L) {
            this.resetLevel();
            return;
        }
        if (this.paused_) {
            if (n == -6) {
                this.parent_.back(this.score_);
            }
            if (n == -7) {
                this.pause();
            }
            return;
        }
        if (n < -5 || n > -1) {
            this.pause();
            return;
        }
        if (n == -5) {
            if (this.player_.shoot()) {
                // empty if block
            }
            if (this.player_.getShots() < this.player_.getMaxShots()) {
                this.playSound(1);
            }
            return;
        }
        if (!this.player_.isMoving()) {
            if (n == -4) {
                this.player_.start(true);
            }
            if (n == -3) {
                this.player_.start(false);
            }
        }
    }

    protected void keyRepeated(int n) {
    }

    protected void keyReleased(int n) {
        if (this.paused_) {
            return;
        }
        if (n == -4 || n == -3) {
            this.player_.stop();
        }
    }

    void startAnimation() {
        this.animation_thread_ = new Thread(this);
        this.animation_thread_.start();
    }

    void stopAnimation() {
        this.animation_thread_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = Thread.currentThread();
        block5: while (true) {
            try {
                while (thread == this.animation_thread_) {
                    long l = System.currentTimeMillis();
                    this.tick();
                    long l2 = System.currentTimeMillis() - l;
                    if (l2 >= (long)this.ms_per_tick_) continue;
                    SRCanvas sRCanvas = this;
                    synchronized (sRCanvas) {
                        this.wait((long)this.ms_per_tick_ - l2);
                        continue block5;
                    }
                }
            }
            catch (InterruptedException interruptedException) {}
            break;
        }
    }

    private synchronized void tick() {
        int n;
        if (this.show_picture_) {
            int n2 = 0;
            while (n2 < 7) {
                if (this.explosions_[n2] == null) {
                    int n3 = Math.abs(this.rnd_.nextInt() % (176 - explosion_images_[0].getWidth()));
                    int n4 = Math.abs(this.rnd_.nextInt() % (65 - explosion_images_[0].getWidth()));
                    this.explosions_[n2] = new Explosion(n3, n4, explosion_images_);
                } else if (this.explosions_[n2].isExploded()) {
                    this.explosions_[n2] = null;
                }
                ++n2;
            }
            this.repaint();
            return;
        }
        if (this.show_level_ && System.currentTimeMillis() - this.timestamp_ > 4000L) {
            this.show_level_ = false;
        }
        if (this.show_game_over_ && System.currentTimeMillis() - this.timestamp_ > 6000L) {
            this.show_game_over_ = false;
            this.stopAnimation();
            this.parent_.back(this.score_);
        }
        if (this.show_game_over_ || this.show_level_) {
            this.repaint();
            return;
        }
        if (this.player_.isMoving()) {
            this.player_.move();
        }
        if (this.player_.removePower()) {
            this.removeLine();
        }
        int n5 = this.player_.getMaxShots();
        int n6 = 0;
        while (n6 < n5) {
            if (this.player_.shots_[n6] != null) {
                this.player_.shots_[n6].move();
                if (this.player_.shots_[n6].getY() < 0) {
                    this.player_.removeShot(n6);
                }
            }
            ++n6;
        }
        if (!this.show_picture_ && !this.show_level_) {
            n6 = 0;
            while (n6 < 10) {
                if (this.monsters_[n6] != null) {
                    if (this.monsters_[n6].isExploded()) {
                        int n7 = this.monsters_[n6].getX() + 5;
                        int n8 = this.monsters_[n6].getY() + 3;
                        int n9 = 0;
                        int n10 = 0;
                        n10 = this.level_ < 6 ? 8 - this.level_ : 2;
                        n9 = Math.abs(this.rnd_.nextInt() % 10) < n10 ? 1 : 0;
                        int n11 = 0;
                        while (n11 < 15) {
                            if (this.goodies_[n11] == null) {
                                ++this.goodie_count_;
                                int n12 = Math.abs(this.rnd_.nextInt() % 2) + 1;
                                this.goodies_[n11] = new Goodie(n7, n8, goodie_images_[n9], n9, n12);
                                break;
                            }
                            ++n11;
                        }
                        this.monsters_[n6] = null;
                        return;
                    }
                    if (!this.monsters_[n6].isExploding()) {
                        this.monsters_[n6].move();
                        if (this.monsters_[n6].getY() >= 67) {
                            this.addLine();
                            this.playSound(0);
                            this.monsters_[n6].explode();
                        }
                    }
                }
                ++n6;
            }
            if (this.spawn_time_ + (long)this.spawn_interval_ <= System.currentTimeMillis()) {
                int n13;
                n = this.level_ < 8 ? 10 + (this.level_ - 1) * 10 : 90;
                if (this.monster_count_ == 10) {
                    n = 0;
                }
                if ((n13 = Math.abs(this.rnd_.nextInt() % 100)) < n) {
                    n6 = 0;
                    while (n6 < 10) {
                        if (this.monsters_[n6] == null) {
                            int n14 = Math.abs(this.rnd_.nextInt() % 5);
                            this.monsters_[n6] = new Monster(monster_images_[n14], explosion_images_);
                            this.spawn_time_ = System.currentTimeMillis();
                            break;
                        }
                        ++n6;
                    }
                }
            }
        }
        n6 = 0;
        while (n6 < 15) {
            if (this.goodies_[n6] != null) {
                this.goodies_[n6].move();
                if (this.goodies_[n6].getY() > 208) {
                    this.goodies_[n6] = null;
                    --this.goodie_count_;
                } else if (this.goodies_[n6].collision(this.player_)) {
                    if (this.goodies_[n6].getType() == 0) {
                        this.playSound(2);
                        this.addLine();
                        this.player_.freeze();
                    } else {
                        this.player_.addPower();
                    }
                    this.goodies_[n6] = null;
                    --this.goodie_count_;
                }
            }
            ++n6;
        }
        n5 = this.player_.getMaxShots();
        n6 = 0;
        while (n6 < n5) {
            if (this.player_.shots_[n6] != null && (n = this.player_.shots_[n6].collisionDetection(this.monsters_, 10)) != -1) {
                this.playSound(0);
                this.player_.removeShot(n6);
                this.monsters_[n].explode();
            }
            ++n6;
        }
        this.repaint();
    }

    public void setMSPerTick(int n) {
        this.ms_per_tick_ = n;
    }

    public int getMSPerTick() {
        return this.standard_ms_per_tick_;
    }

    public int getMaxX() {
        return 176;
    }

    public int getMaxY() {
        return 208;
    }

    public void reset() {
        this.level_ = 0;
        this.first_ = true;
        this.show_game_over_ = false;
        this.num_lines_ = 7;
    }

    public void resetLevel() {
        ++this.level_;
        this.player_.resetPlayer();
        this.current_girl_ = (this.level_ - 1) % 10;
        this.spawn_interval_ = this.level_ < 10 ? 2000 - (this.level_ - 1) * 200 : 200;
        this.num_lines_ = 8;
        this.show_level_ = true;
        this.show_picture_ = false;
        this.exp_timestamp_ = this.timestamp_ = System.currentTimeMillis();
        this.monster_count_ = 0;
        int n = 0;
        while (n < 10) {
            this.monsters_[n] = null;
            ++n;
        }
        this.goodie_count_ = 0;
        n = 0;
        while (n < 15) {
            this.goodies_[n] = null;
            ++n;
        }
        n = 0;
        while (n < 5) {
            this.explosions_[n] = null;
            ++n;
        }
        this.startAnimation();
    }

    public void reduceLines() {
        this.playSound(3);
        if (--this.num_lines_ == 0) {
            if (++this.current_girl_ == 10) {
                this.current_girl_ = 0;
            }
            this.num_lines_ = 9;
        }
    }

    public synchronized void playSound(int n) {
        if (!this.sound_on_) {
            return;
        }
        int n2 = explosion_sound_.getState() + shot_sound_.getState() + hit_sound_.getState() + line_rem_sound_.getState() + gameover_sound_.getState();
        if (n2 < 5) {
            return;
        }
        explosion_sound_.stop();
        shot_sound_.stop();
        hit_sound_.stop();
        line_rem_sound_.stop();
        gameover_sound_.stop();
        switch (n) {
            case 0: {
                explosion_sound_.play(1);
                break;
            }
            case 1: {
                shot_sound_.play(1);
                break;
            }
            case 2: {
                hit_sound_.play(1);
                break;
            }
            case 3: {
                line_rem_sound_.play(1);
                break;
            }
            case 4: {
                gameover_sound_.play(1);
            }
        }
    }

    public void setSound(boolean bl) {
        this.sound_on_ = bl;
    }

    private void showLevelScreen(Graphics graphics) {
        graphics.setColor(8192120);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.drawImage(title_image_, 0, 0, 4 | 0x10);
        String string = this.level_ < 10 ? "Level: 0" + this.level_ : "Level: " + this.level_;
        int n = (this.getWidth() - this.font_.stringWidth(string)) / 2;
        graphics.setColor(0xFFFFFF);
        graphics.setFont(this.font_);
        graphics.drawString(string, n, title_image_.getHeight() + 20, 20);
    }

    private void addLine() {
        if (++this.num_lines_ == 17) {
            this.playSound(4);
            this.show_game_over_ = true;
            this.timestamp_ = System.currentTimeMillis();
            this.repaint();
        }
    }

    private void removeLine() {
        if (--this.num_lines_ == 0) {
            this.show_picture_ = true;
            this.pic_timestamp_ = System.currentTimeMillis();
        }
    }

    private void pause() {
        boolean bl = this.paused_ = !this.paused_;
        if (this.paused_) {
            this.stopAnimation();
            this.repaint();
        } else {
            this.startAnimation();
        }
    }

    static {
        girl_images_ = new Image[10];
        explosion_images_ = new Image[3];
        monster_images_ = new Image[5][2];
        goodie_images_ = new Image[2][2];
    }
}

