/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Monster {
    private static Random rnd_;
    private int pos_x_;
    private int pos_y_;
    private boolean draw_first_image_ = true;
    private long timestamp_ = 0L;
    private Image[] monster_images_;
    private static Image[] explosion_images_;
    private boolean exploding_ = false;
    private int current_explode_image_ = 0;
    private boolean is_exploded_ = false;
    private static int height;
    private static int width;
    private boolean move_now_ = true;

    public Monster(Image[] imageArray, Image[] imageArray2) {
        rnd_ = new Random(System.currentTimeMillis());
        int n = Math.abs(rnd_.nextInt() % 8);
        this.pos_x_ = 13 + n * 20;
        this.monster_images_ = imageArray;
        explosion_images_ = imageArray2;
        height = imageArray[0].getHeight();
        width = imageArray[0].getWidth();
    }

    public void drawMonster(Graphics graphics) {
        if (this.is_exploded_) {
            graphics.drawImage(explosion_images_[2], this.pos_x_, this.pos_y_, 0);
            return;
        }
        if (this.exploding_) {
            if (this.timestamp_ + 300L <= System.currentTimeMillis()) {
                ++this.current_explode_image_;
                this.timestamp_ = System.currentTimeMillis();
                if (this.current_explode_image_ == 3) {
                    this.is_exploded_ = true;
                    return;
                }
            }
            graphics.drawImage(explosion_images_[this.current_explode_image_], this.pos_x_, this.pos_y_, 0);
            return;
        }
        if (!this.exploding_) {
            if (this.draw_first_image_) {
                graphics.drawImage(this.monster_images_[0], this.pos_x_, this.pos_y_, 20);
            } else {
                graphics.drawImage(this.monster_images_[1], this.pos_x_, this.pos_y_, 20);
            }
            if (this.timestamp_ + 500L < System.currentTimeMillis()) {
                this.timestamp_ = System.currentTimeMillis();
                this.draw_first_image_ = !this.draw_first_image_;
            }
        }
    }

    public void move() {
        if (this.is_exploded_ || this.exploding_) {
            return;
        }
        if (this.move_now_) {
            ++this.pos_y_;
        }
        this.move_now_ = !this.move_now_;
    }

    public int getX() {
        return this.pos_x_;
    }

    public int getY() {
        return this.pos_y_;
    }

    public static int getWidth() {
        return width;
    }

    public static int getHeight() {
        return height;
    }

    public void explode() {
        if (this.is_exploded_ || this.exploding_) {
            return;
        }
        this.exploding_ = true;
        this.timestamp_ = System.currentTimeMillis() - 200L;
    }

    public boolean isExploded() {
        return this.is_exploded_;
    }

    public boolean isExploding() {
        return this.exploding_;
    }
}

