/*
 * Decompiled with CFR 0.152.
 */
package com.paff.nokiasound;

import com.nokia.mid.sound.Sound;
import com.paff.nokiasound.SoundException;
import java.io.IOException;
import java.io.InputStream;

public class NokiaSound {
    private Sound[] sounds_;
    private int maxSounds_;
    private boolean bSound_ = true;
    private SoundException exc_;

    public NokiaSound(int maxSnd) {
        this.maxSounds_ = maxSnd;
        this.sounds_ = new Sound[maxSnd];
    }

    public void setSound(boolean bSoundOn) {
        this.bSound_ = bSoundOn;
    }

    public void addSound(int sndNr, String sndFile, int sndBytes) throws SoundException {
        if (this.bSound_) {
            try {
                InputStream wav_in = this.getClass().getResourceAsStream(sndFile);
                byte[] buffer = new byte[sndBytes];
                wav_in.read(buffer, 0, buffer.length);
                this.sounds_[sndNr - 1] = new Sound(buffer, 5);
                this.sounds_[sndNr - 1].init(buffer, 5);
                wav_in.close();
            }
            catch (IOException e) {
                this.exc_ = new SoundException("Fehler @ addSound");
            }
        }
    }

    public void addSound(int sndNr, byte[] data) {
        if (this.bSound_) {
            this.sounds_[sndNr - 1] = new Sound(data, 1);
        }
    }

    public void playSound(int sndNr, int playType) {
        if (this.bSound_) {
            try {
                int i = 0;
                while (i < this.maxSounds_) {
                    this.sounds_[i].stop();
                    ++i;
                }
                this.sounds_[sndNr - 1].play(playType);
            }
            catch (NullPointerException e) {
                System.out.println("playSound threw a NullPointerException: " + ((Throwable)e).getMessage());
            }
        }
    }

    public void stopAllSounds() {
        if (this.bSound_) {
            int i = 0;
            while (i < this.maxSounds_) {
                this.sounds_[i].stop();
                ++i;
            }
        }
    }

    public void deInit() {
        if (this.bSound_) {
            int i = 0;
            while (i < this.maxSounds_) {
                this.sounds_[i].stop();
                ++i;
            }
            int y = 0;
            while (y < this.maxSounds_) {
                this.sounds_[y].release();
                ++y;
            }
        }
        int x = 0;
        while (x < this.maxSounds_) {
            this.sounds_[x] = null;
            ++x;
        }
        this.sounds_ = null;
    }
}

