/*
 * Decompiled with CFR 0.152.
 */
package com.paff.menu;

import com.nokia.mid.ui.FullCanvas;
import com.paff.menu.MenuException;
import com.paff.menu.MenuHandler;
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;

public class FullMenu
extends FullCanvas
implements CommandListener,
Runnable {
    private MenuHandler parent_;
    private Display display_;
    private Thread thread_ = null;
    private boolean bAlive_ = false;
    private MenuException exc_ = null;
    private int itemcount_ = 0;
    private boolean bDraw_ = false;
    private boolean bDrawBackground_ = false;
    private Image imageBackground_ = null;
    private int posXBackground_ = 0;
    private int posYBackground_ = 0;
    private int backgroundColor_ = 0xFFFFFF;
    private Image addImage_ = null;
    private boolean bDrawAddImage_ = false;
    private int addPosX_ = 0;
    private int addPosY_ = 0;
    private boolean bDrawIcons_ = false;
    private Image[] imageIcon_;
    private Font menuFont;
    private String[] imageTags_;
    private String noSound_;
    private int posYTags_ = 0;
    private int imageCount_ = 0;
    private int posYIcons_ = 0;
    private int width_ = 0;
    private int height_ = 0;
    private int difference_ = 0;
    private int state_ = 0;
    private boolean bDrawSoundOff_ = false;
    private Image imageSoundOff_;
    private int soundOffPos_ = -1;
    private boolean bSound = true;
    private int textColor_ = 0;
    private int frameColor_ = 0;
    private Command backCmd;
    private boolean bBackCmdSet = false;
    private Form infoForm;
    private StringItem infoItem;
    private String infoString_ = "";
    private int infoPos_ = -1;
    private Form helpForm;
    private StringItem helpItem;
    private String helpString_ = "";
    private int helpPos_ = -1;
    private int startPos_ = -1;
    private int exitPos_ = -1;
    private boolean bFade = false;
    private long fadeVelocity = 0L;
    private long fade_start_ = 0L;
    private long fade_end_ = 0L;
    private int iFadePosX_ = 0;
    private int iFadePosY_ = 0;
    private int iDirection_ = -1;
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;

    public FullMenu(MenuHandler parent) {
        this.parent_ = parent;
        this.menuFont = Font.getDefaultFont();
    }

    public void setBackground(String background, int posX, int posY) throws MenuException {
        try {
            this.imageBackground_ = Image.createImage((String)background);
            this.posXBackground_ = posX;
            this.posYBackground_ = posY;
            this.bDrawBackground_ = true;
        }
        catch (IOException e) {
            this.exc_ = new MenuException("error loading background image");
            throw this.exc_;
        }
    }

    public void setAddImage(String additionImage, int posX, int posY) throws MenuException {
        try {
            this.addImage_ = Image.createImage((String)additionImage);
            this.addPosX_ = posX;
            this.addPosY_ = posY;
            this.bDrawAddImage_ = true;
        }
        catch (IOException e) {
            this.exc_ = new MenuException("error loading background image");
            throw this.exc_;
        }
    }

    public void setBackgroundColor(int rgbColor) {
        this.backgroundColor_ = rgbColor;
    }

    public void setFont(Font font) {
        this.menuFont = font;
    }

    public void setIcons(String[] imageNames, String[] imageTags, int width, int height) throws MenuException {
        int imageCount = imageNames.length;
        this.imageTags_ = imageTags;
        this.imageIcon_ = new Image[imageCount];
        try {
            this.imageCount_ = imageCount;
            this.width_ = width;
            this.height_ = height;
            this.posYIcons_ = this.getHeight() - height - 1;
            this.posYTags_ = this.posYIcons_ - this.menuFont.getHeight() - 1;
            int index = 0;
            while (index < imageCount) {
                this.imageIcon_[index] = Image.createImage((String)imageNames[index]);
                ++index;
            }
            this.difference_ = this.getWidth() - width * imageCount;
            this.difference_ /= imageCount + 1;
            this.bDrawIcons_ = true;
        }
        catch (IOException e) {
            this.exc_ = new MenuException("error loading icon images");
            throw this.exc_;
        }
        catch (NullPointerException e) {
            this.exc_ = new MenuException("error nullpointer");
            throw this.exc_;
        }
    }

    public void setIconPosY(int posY) {
        this.posYIcons_ = posY;
    }

    public void setIconTagPosY(int posY) {
        this.posYTags_ = posY;
    }

    public void setInfo(String appName, String infoString, int infoPos) throws MenuException {
        if (!this.bBackCmdSet) {
            this.exc_ = new MenuException("error - setBackCommand(String backString) has to be called before setInfo(String appName,String infoString,int infoPos)");
            throw this.exc_;
        }
        this.infoString_ = infoString;
        this.infoPos_ = infoPos - 1;
        this.infoForm = new Form(appName);
        this.infoItem = new StringItem("", infoString);
        this.infoForm.append((Item)this.infoItem);
        this.infoForm.addCommand(this.backCmd);
        this.infoForm.setCommandListener((CommandListener)this);
    }

    public void setHelp(String appName, String helpString, int helpPos) throws MenuException {
        if (!this.bBackCmdSet) {
            this.exc_ = new MenuException("error - setBackCommand(String backString) has to be called before setHelp(String appName,String helpString,int helpPos)");
            throw this.exc_;
        }
        this.helpString_ = helpString;
        this.helpPos_ = helpPos - 1;
        this.helpForm = new Form(appName);
        this.helpItem = new StringItem("", helpString);
        this.helpForm.append((Item)this.helpItem);
        this.helpForm.addCommand(this.backCmd);
        this.helpForm.setCommandListener((CommandListener)this);
    }

    public void setBackCommand(String backString) {
        this.backCmd = new Command(backString, 2, 0);
        this.bBackCmdSet = true;
    }

    public void setStartApplication(int startPos) {
        this.startPos_ = startPos - 1;
    }

    public void setExitApplication(int exitPos) {
        this.exitPos_ = exitPos - 1;
    }

    public void setFadeIn(int Direction, long velocity) {
        this.bFade = true;
        this.fadeVelocity = velocity;
        switch (Direction) {
            case 1: {
                this.iFadePosX_ = 0;
                this.iFadePosY_ = this.getHeight();
                break;
            }
            case 2: {
                this.iFadePosX_ = 0;
                this.iFadePosY_ = 0 - this.getHeight();
                break;
            }
            case 3: {
                this.iFadePosX_ = this.getWidth();
                this.iFadePosY_ = 0;
                break;
            }
            case 4: {
                this.iFadePosX_ = 0 - this.getWidth();
                this.iFadePosY_ = 0;
            }
        }
        this.iDirection_ = Direction;
    }

    public void setSoundOffImage(String imageSoundOff, String imageSoundOffTag, int imagePos) throws MenuException {
        this.noSound_ = imageSoundOffTag;
        try {
            this.soundOffPos_ = imagePos - 1;
            this.imageSoundOff_ = Image.createImage((String)imageSoundOff);
        }
        catch (IOException e) {
            this.exc_ = new MenuException("error loading sound off image");
            throw this.exc_;
        }
    }

    public void setTextColor(int rgbColor) {
        this.textColor_ = rgbColor;
    }

    public void setFrameColor(int rgbColor) {
        this.frameColor_ = rgbColor;
    }

    public void show(Display display) {
        this.bDraw_ = true;
        this.display_ = display;
        display.setCurrent((Displayable)this);
        this.thread_ = new Thread(this);
        this.bAlive_ = true;
        this.fade_start_ = System.currentTimeMillis();
        this.thread_.start();
    }

    public void hide() {
        this.bDrawBackground_ = false;
        this.bDrawAddImage_ = false;
        this.bDrawIcons_ = false;
        this.bDrawSoundOff_ = false;
        this.bDraw_ = false;
        this.imageBackground_ = null;
        this.imageIcon_ = null;
        this.imageSoundOff_ = null;
        this.bAlive_ = false;
    }

    public void paint(Graphics g) {
        g.setColor(this.backgroundColor_);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(0);
        g.setFont(this.menuFont);
        if (this.bDraw_) {
            if (this.bFade) {
                g.drawImage(this.imageBackground_, this.iFadePosX_, this.iFadePosY_, 0);
            } else {
                if (this.bDrawBackground_) {
                    g.drawImage(this.imageBackground_, this.posXBackground_, this.posYBackground_, 0);
                }
                if (this.bDrawIcons_) {
                    int index = 0;
                    while (index < this.imageCount_) {
                        g.drawImage(this.imageIcon_[index], this.difference_ * (index + 1) + this.width_ * index, this.posYIcons_, 0);
                        ++index;
                    }
                    if (this.bDrawSoundOff_ && !this.bSound) {
                        g.drawImage(this.imageSoundOff_, this.difference_ * (this.soundOffPos_ + 1) + this.width_ * this.soundOffPos_, this.posYIcons_, 0);
                    }
                    g.setColor(this.frameColor_);
                    g.drawRect(this.difference_ * (this.state_ + 1) + this.width_ * this.state_ - 1, this.posYIcons_ - 1, this.width_, this.height_);
                    g.setColor(this.textColor_);
                    if (this.state_ == this.soundOffPos_) {
                        if (this.bSound) {
                            g.drawString(this.imageTags_[this.state_], this.getWidth() / 2 - this.menuFont.stringWidth(this.imageTags_[this.state_]) / 2, this.posYTags_, 0);
                        } else {
                            g.drawString(this.noSound_, this.getWidth() / 2 - this.menuFont.stringWidth(this.noSound_) / 2, this.posYTags_, 0);
                        }
                    } else {
                        g.drawString(this.imageTags_[this.state_], this.getWidth() / 2 - this.menuFont.stringWidth(this.imageTags_[this.state_]) / 2, this.posYTags_, 0);
                    }
                }
            }
        }
    }

    public void run() {
        while (this.bAlive_) {
            if (!this.bFade) continue;
            this.fade_end_ = System.currentTimeMillis();
            if (this.fade_end_ - this.fade_start_ < this.fadeVelocity) continue;
            switch (this.iDirection_) {
                case 1: {
                    if (this.iFadePosY_ <= this.posYBackground_) {
                        this.bFade = false;
                        this.repaint();
                        break;
                    }
                    --this.iFadePosY_;
                    this.repaint();
                    break;
                }
                case 2: {
                    if (this.iFadePosY_ >= this.posYBackground_) {
                        this.bFade = false;
                        this.repaint();
                        break;
                    }
                    ++this.iFadePosY_;
                    this.repaint();
                    break;
                }
                case 3: {
                    if (this.iFadePosX_ <= this.posXBackground_) {
                        this.bFade = false;
                        this.repaint();
                        break;
                    }
                    --this.iFadePosX_;
                    this.repaint();
                    break;
                }
                case 4: {
                    if (this.iFadePosX_ >= this.posXBackground_) {
                        this.bFade = false;
                        this.repaint();
                        break;
                    }
                    ++this.iFadePosX_;
                    this.repaint();
                }
            }
            this.fade_start_ = System.currentTimeMillis();
        }
    }

    protected void keyPressed(int keyCode) {
        if (this.bFade) {
            this.bFade = false;
            this.repaint();
            return;
        }
        switch (keyCode) {
            case -3: 
            case -1: 
            case 52: {
                --this.state_;
                if (this.state_ >= 0) break;
                this.state_ = this.imageCount_ - 1;
                break;
            }
            case -4: 
            case -2: 
            case 54: {
                ++this.state_;
                if (this.state_ <= this.imageCount_ - 1) break;
                this.state_ = 0;
                break;
            }
            case -10: 
            case -7: 
            case -6: 
            case -5: 
            case 53: {
                if (this.startPos_ == this.state_) {
                    this.parent_.startApplication(this.bSound);
                }
                if (this.exitPos_ == this.state_) {
                    this.parent_.exitApplication();
                }
                if (this.infoPos_ == this.state_) {
                    this.display_.setCurrent((Displayable)this.infoForm);
                }
                if (this.helpPos_ == this.state_) {
                    this.display_.setCurrent((Displayable)this.helpForm);
                }
                if (this.soundOffPos_ != this.state_) break;
                this.bSound = !this.bSound;
                this.bDrawSoundOff_ = !this.bSound;
            }
        }
        this.repaint();
    }

    protected void keyReleased(int keyCode) {
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.backCmd) {
            this.display_.setCurrent((Displayable)this);
        }
    }

    static {
        UP = 1;
        DOWN = 2;
        LEFT = 3;
        RIGHT = 4;
    }
}

